package gov.va.med.mhv.health.converter;

import gov.va.med.mhv.health.dto.ChemistryLabDTO;
import gov.va.med.mhv.health.dto.ChemistryPanelDTO;
import gov.va.med.mhv.health.dto.ChemistryTestDTO;
import gov.va.med.mhv.health.model.ChemistryLab;
import gov.va.med.mhv.health.model.ChemistryPanel;
import gov.va.med.mhv.health.model.ChemistryTest;

import java.util.ArrayList;
import java.util.List;

public class ChemistryLabConverter {
	
	public static ChemistryLabDTO  convertChemLabDomain(ChemistryLab chemlab ){
		
		ChemistryLabDTO dto = new ChemistryLabDTO();
		dto.setAmendedStatus(chemlab.getAmendedStatus());
		dto.setChemistryLabId(chemlab.getId());
		dto.setCollectedDateImprecise(chemlab.getCompletedDateImprecise());
		dto.setCollectedDatePrecise(chemlab.getCollectedDatePrecise());
		dto.setCollectionSample(chemlab.getCollectionSample());
		dto.setComments(chemlab.getComments());
		dto.setCompletedDateImprecise(chemlab.getCompletedDateImprecise());
		dto.setCompletedDatePrecise(chemlab.getCompletedDatePrecise());
		dto.setFacilityControlId(chemlab.getFacilityControlId());
		dto.setFacilityInfoId(chemlab.getFacilityInfoId());
		dto.setLabType(chemlab.getLabType());
		dto.setLid(chemlab.getLid());
		dto.setOrderingLocation(chemlab.getOrderingLocation());
		dto.setOrderingProvider(chemlab.getOrderingProvider());
		//setChemistryPanels(dto,chemlab);
		dto.setPatientId(chemlab.getPatientId());
		dto.setRecordId(chemlab.getRecordId());
		dto.setReportText(chemlab.getReportText());
		dto.setSpecimenSource(chemlab.getSpecimenSource());
		dto.setStationNumber(chemlab.getStationNumber());
		return dto;
	}

/*	private static void setChemistryPanels(ChemistryLabDTO dto,	ChemistryLab chemlab) {
		Set<ChemistryPanel> chemPanels = chemlab.getPanels();
		Set<ChemistryPanelDTO> dtos = new HashSet<ChemistryPanelDTO>();
		for(ChemistryPanel panel:  chemPanels){
			ChemistryPanelDTO panelDTO =  new ChemistryPanelDTO();
			panelDTO.setAmendedStatus(panel.getAmendedStatus());
			panelDTO.setChemistryPanelId(panel.getId());
			setChemistryTests(panelDTO,panel);
			panelDTO.setCreatedDate(panel.getCreatedDate());
			panelDTO.setLid(panel.getLid());
			panelDTO.setOrderedTest(panel.getOrderedTest());
			panelDTO.setPatientId(panel.getPatientId());
			panelDTO.setPid(panel.getPid());
			dtos.add(panelDTO);
		}
		dto.setPanels(dtos);
	}  */

	private static void setChemistryTests(ChemistryPanelDTO panelDTO,ChemistryPanel panel) {
		
		List<ChemistryTest> chemTests= panel.getChemistryTests();
		List<ChemistryTestDTO> dtos = new ArrayList<ChemistryTestDTO>();
		if(chemTests != null){
			for(ChemistryTest  chemTest : chemTests){
				ChemistryTestDTO dto = new ChemistryTestDTO();
				dto.setChemistryTestId(chemTest.getId());
				dto.setInterpretation(chemTest.getInterpretation());
				dto.setLabTestName(chemTest.getLabTestName());
				dto.setPerformingLocation(chemTest.getPerformingLocation());
				dto.setPerformingLoctaionName(chemTest.getPerformingLoctaionName());
				dto.setReferenceRange(chemTest.getReferenceRange());
				dto.setResult(chemTest.getResult());
				dto.setResultIndicator(chemTest.getResultIndicator());
				dto.setStationNumber(chemTest.getStationNumber());
				dto.setStatus(chemTest.getStatus());
				dto.setUnits(chemTest.getUnits());
				dto.setOrderedTest(panel.getOrderedTest());
				dtos.add(dto);
			}
		}
		panelDTO.setChemistryTests(dtos);
	}
	
	public static List<ChemistryLabDTO>  convertChemLabRecords( List<ChemistryLab> chemlabs ){
		List<ChemistryLabDTO> dtos = new ArrayList<ChemistryLabDTO>();
		for(ChemistryLab chemlab : chemlabs){
			ChemistryLabDTO dto = convertChemLabDomain(chemlab);
			dtos.add(dto);
		}
		return dtos;
	}
	
	public static ChemistryPanelDTO  convertChemPanelDomain(ChemistryPanel panel ){
		ChemistryPanelDTO panelDTO =  new ChemistryPanelDTO();
		panelDTO.setAmendedStatus(panel.getAmendedStatus());
		panelDTO.setChemistryPanelId(panel.getId());
		setChemistryTests(panelDTO,panel);
		panelDTO.setCreatedDate(panel.getCreatedDate());
		panelDTO.setLid(panel.getLid());
		panelDTO.setOrderedTest(panel.getOrderedTest());
		panelDTO.setPatientId(panel.getPatientId());
		panelDTO.setPid(panel.getPid());
		return panelDTO;
	}
	
	public static List<ChemistryPanelDTO>  convertChemPanelRecords( List<ChemistryPanel> chempanels ){
		List<ChemistryPanelDTO> dtos = new ArrayList<ChemistryPanelDTO>();
		for(ChemistryPanel chempanel : chempanels){
			ChemistryPanelDTO dto = convertChemPanelDomain(chempanel);
			dtos.add(dto);
		}
		return dtos;
	}
}
